<?php

namespace App\Events;

use App\Models\Interview;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;

class InterviewStatusChanged implements ShouldBroadcast
{
    use InteractsWithSockets, SerializesModels;

    public $interview;

    public function __construct(Interview $interview)
    {
        $this->interview = $interview;
    }

    public function broadcastOn()
    {
        return new Channel('interviews');
    }

    public function broadcastWith()
    {
        $application = $this->interview->application;
        $candidateUserId = $application->User_id;

        return [
            'interview' => $this->interview->only(['Interview_id', 'Application_id', 'Status', 'Date']),
            'candidate_id' => $candidateUserId,
        ];
    }
}
